# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import SDArray
from .sdplugin import SDPlugin
from .sdapiobject import SDAPIObject
from .sdplugin import SDPluginStatus
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDPluginMgr(SDAPIObject):
    """
    Manages plugins. There is only one SDPluginMgr, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDPluginMgr
        """
        super(SDPluginMgr, self).__init__(APIContext, handle, *args, **kwargs)

    def getPlugins(self) -> SDArray[SDPlugin]:
        """
        Get the available plugins

        """
        outPlugins = ctypes.c_void_p()
        _res = self.mAPIContext.SDPluginMgr_getPlugins(self.mHandle, ctypes.byref(outPlugins))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPlugins, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPlugins.value, ownHandle=True)

    def loadPlugin(self, inPluginName : str, inPluginDir : str) -> SDPlugin:
        """
        Load a plugin

        :param inPluginName: The plugin name
        :param inPluginDir: The directory where the plugin is located
        """
        outSDPlugin = ctypes.c_void_p()
        _res = self.mAPIContext.SDPluginMgr_loadPlugin(self.mHandle, ctypes.create_string_buffer(inPluginName.encode('utf-8')), ctypes.create_string_buffer(inPluginDir.encode('utf-8')), ctypes.byref(outSDPlugin))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDPlugin, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDPlugin.value, ownHandle=True)

    def unloadPlugin(self, inPlugin : SDPlugin) -> None:
        """
        Unload a plugin

        :param inPlugin: The plugin to unload
        """
        _res = self.mAPIContext.SDPluginMgr_unloadPlugin(self.mHandle, inPlugin.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getUserPluginsDir(self) -> str:
        """
        Get the user plugins directory

        """
        outPluginDir = ctypes.c_char_p()
        _res = self.mAPIContext.SDPluginMgr_getUserPluginsDir(self.mHandle, ctypes.byref(outPluginDir))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPluginDir.value.decode('utf-8') # type: ignore

    def checkPluginCompatibility(self, inMetadata : str) -> Optional[str]:
        """
        Check if a plugin is compatible with this Designer version

        :param inMetadata: A string with JSON encoded plugin metadata
        """
        outErrorMessage = ctypes.c_char_p()
        _res = self.mAPIContext.SDPluginMgr_checkPluginCompatibility(self.mHandle, ctypes.create_string_buffer(inMetadata.encode('utf-8')), ctypes.byref(outErrorMessage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outErrorMessage.value.decode('utf-8') # type: ignore

